/*
 * Copyright (C) 2010, Panasonic Corporation 
 */

#if defined(CONFIG_USB_PANASONIC_SLD3)

static inline void internal_host_peripheryhw_init( void )
{

	outl( 0x00000001, 0x59810114 );
	outl( 0x00000001, 0x59810314 );
	outl( 0x00000001, 0x59810514 );
	outl( 0x00000001, 0x59810714 );
#if 0

	outl( 0x00010000, 0x59810030 );
	outl( 0x00010000, 0x59810230 );
	outl( 0x00010000, 0x59810430 );

	outl( 0x00001100, 0x5A000030 );
	outl( 0x00001100, 0x5A010010 );
	outl( 0x00001100, 0x5A010030 );
#endif


}

#define INTERNAL_EHCI_BASE_ADR_0	(0x5A800000)
#define INTERNAL_EHCI_IRQ_NUM_0		(112)
#define INTERNAL_EHCI_BASE_ADR_1	(0x5A810000)
#define INTERNAL_EHCI_IRQ_NUM_1		(113)
#define INTERNAL_EHCI_BASE_ADR_2	(0x5A820000)
#define INTERNAL_EHCI_IRQ_NUM_2		(114)
#define INTERNAL_EHCI_BASE_ADR_3	(0x5A830000)
#define INTERNAL_EHCI_IRQ_NUM_3		(115)
#define USBH_EHCI_BURSTSIZE         (0x00004080)
#define USBH_EHCI_TXFILLTUNING      (0x00020000)
#define INTERNAL_EHCI_MEM_LEN       (0x200)
#define INTERNAL_EHCI_CAPS_BASE     (0x0100)
#define INTERNAL_EHCI_REGS_BASE     (0x0140)
#define USBH_IOBASEADDR       		(0x0)

static const struct resource host_res[][2] = {
	{
		{
			.start	= INTERNAL_EHCI_BASE_ADR_0,
			.end	= INTERNAL_EHCI_BASE_ADR_0 + INTERNAL_EHCI_MEM_LEN - 1,
			.flags	= IORESOURCE_MEM,
		}, {
			.start	= INTERNAL_EHCI_IRQ_NUM_0,
			.flags	= IORESOURCE_IRQ,
		},
	},
	{
		{
			.start	= INTERNAL_EHCI_BASE_ADR_1,
			.end	= INTERNAL_EHCI_BASE_ADR_1 + INTERNAL_EHCI_MEM_LEN - 1,
			.flags	= IORESOURCE_MEM,
		}, {
			.start	= INTERNAL_EHCI_IRQ_NUM_1,
			.flags	= IORESOURCE_IRQ,
		},
	},
	{
		{
			.start	= INTERNAL_EHCI_BASE_ADR_2,
			.end	= INTERNAL_EHCI_BASE_ADR_2 + INTERNAL_EHCI_MEM_LEN - 1,
			.flags	= IORESOURCE_MEM,
		}, {
			.start	= INTERNAL_EHCI_IRQ_NUM_2,
			.flags	= IORESOURCE_IRQ,
		},
	},
	{
		{
			.start	= INTERNAL_EHCI_BASE_ADR_3,
			.end	= INTERNAL_EHCI_BASE_ADR_3 + INTERNAL_EHCI_MEM_LEN - 1,
			.flags	= IORESOURCE_MEM,
		}, {
			.start	= INTERNAL_EHCI_IRQ_NUM_3,
			.flags	= IORESOURCE_IRQ,
		},
	},
};



#ifdef CONFIG_USB_PANASONIC_HOST_INTRMEM

#define INTERMEM_SIZE	16384
#define INTERMEM_OFFSET	0x4000
typedef struct _INTERMEM_CONFIG{
	int size;
	int num;
} INTERMEM_CONFIG;

static const INTERMEM_CONFIG intermem_configuration[]={

#ifdef CONFIG_USB_PANASONIC_HOST
	{	2048,	1},
#else
	{	1024,	2},
#endif
	{	128,	112},
};
#endif
#endif /* CONFIG_USB_PANASONIC_SLD3 */

